﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Windows.Forms;
using FDK;

namespace StrokeStyleT
{
	class CStageオープニング : CActivity
	{
		public CStageオープニング()
		{
			this.list子Activities.Add( this.Actログインユーザ選択 = new CActユーザ選択() );
		}

		public override void Onリソースの作成()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			string path = Folder.stgテーマファイル( @"ScreenTitle demo.mp4" );
			this.msオープニング動画 = new CMediaSession();
			this.msオープニング動画.t構築する( Global.App.hWindow, path, false, false );

			var ms = new MemoryStream();
			C音声ストリーム抽出.tWAVイメージ抽出( path, out ms );
			this.sdオープニング音声 = Global.SoundDevice.tサウンドを作成する( ms.ToArray() );

			base.Onリソースの作成();
		}
		public override void Onリソースの作成( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			try
			{
				this.txタイトル画面 = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenTitle.jpg" ), D3DFormat.A8R8G8B8, false );
			}
			catch
			{
				this.txタイトル画面 = null;
			}

			base.Onリソースの作成( hDevice );
		}
		public override void Onリソースの解放()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			if( this.msオープニング動画.b再生中 )
				this.msオープニング動画.t停止する();

			Global.tDisposeする( this.sdオープニング音声 );
			Global.tDisposeする( this.msオープニング動画 );
			Global.tDisposeする( this.txタイトル画面 );
			
			base.Onリソースの解放();
		}

		protected enum EフェーズID { デモ, 輝度低下, ログイン, フェードアウト, 即終了 }
		protected Cスレッドセーフ<EフェーズID> eフェーズID = new Cスレッドセーフ<EフェーズID>( EフェーズID.デモ );

		public override int On進行()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				throw new Exception( "活性化していません。" );
			//-----------------
			#endregion

			if( this.b初めての進行 )
			{
				this.eフェーズID.Set( EフェーズID.デモ );
				this.msオープニング動画.t再生する( 0, this.sdオープニング音声 );	// 動画と音声を同期して再生する。
				this.Actログインユーザ選択.tリセット();
				this.b初めての進行 = false;
			}

			switch( this.eフェーズID.Get() )
			{
				case EフェーズID.デモ:
					#region [ 動画の再生が終了すれば動画と音声を停止し、次のフェーズへ。 ]
					//-----------------
					if( this.msオープニング動画.eMediaSessionの状態 == CMediaSession.EMediaSessionの状態.再生終了 )
					{
						this.msオープニング動画.t停止する();
						this.sdオープニング音声.t停止する();
						this.ct輝度低下 = new CCounter( 10, 162, 6 );
						this.eフェーズID.Set( EフェーズID.輝度低下 );
					}
					break;
					//-----------------
					#endregion

				case EフェーズID.輝度低下:
					#region [ 画面の輝度を徐々に下げる。]
					//-----------------
					if( this.ct輝度低下.b終了値に達してない )
					{
						this.ct輝度低下.t進行();
					}
					else
					{
						this.eフェーズID.Set( EフェーズID.ログイン );
					}
					break;
					//-----------------
					#endregion

				case EフェーズID.ログイン:
					#region [ ログインユーザが選択 or キャンセルされるのを待ち、選択されていればログイン処理する。（キャンセルの場合はフロー制御で分岐する）]
					//-----------------
					if( this.Actログインユーザ選択.On進行() == (int) E進行結果.完了 )
					{
						if( !string.IsNullOrEmpty( this.Actログインユーザ選択.stg選択されたユーザ名 ) )
							Global.User.tログインする( this.Actログインユーザ選択.stg選択されたユーザ名 );
							
						this.eフェーズID.Set( EフェーズID.フェードアウト );
					}
					break;
					//-----------------
					#endregion

				case EフェーズID.フェードアウト:
				case EフェーズID.即終了:
					return (int) E進行結果.完了;
			}

			#region [ ESC → 終了 ]
			//-----------------
			if( Global.Input.Input管理.Keyboard.bキーが押された( Key.Escape ) )
				Global.App.bアプリケーションを終了する.Set( true );
			//-----------------
			#endregion

			return (int) E進行結果.継続;
		}
		public override void On描画前()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない || Global.App.bアプリケーションを終了する.Get() )
				return;
			//-----------------
			#endregion

			switch( this.eフェーズID.Get() )
			{
				case EフェーズID.ログイン:
					this.Actログインユーザ選択.On描画前();
					break;
			}
			
		}
		public override void On描画( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない || Global.App.bアプリケーションを終了する.Get() )
				return;
			//-----------------
			#endregion

			switch( this.eフェーズID.Get() )
			{
				case EフェーズID.デモ:
					#region [ 動画テクスチャを描画する。]
					//-----------------
					if( this.msオープニング動画 != null )
						this.msオープニング動画.t最新のサンプルを描画する();
					break;
					//-----------------
					#endregion

				case EフェーズID.輝度低下:
				case EフェーズID.ログイン:
					#region [ txタイトル画面を描画。]
					//-----------------
					if( this.txタイトル画面 != null )
					{
						this.txタイトル画面.n透明度 = 255 - this.ct輝度低下.n現在の値;
						this.txタイトル画面.t2D描画( hDevice, 0, 0 );
					}
					break;
					//-----------------
					#endregion

				case EフェーズID.フェードアウト:
					break;
			}
		}

		CActユーザ選択 Actログインユーザ選択 = null;
		CMediaSession msオープニング動画 = null;
		CSound sdオープニング音声 = null;
		CTexture txタイトル画面 = null;
		CCounter ct輝度低下 = null;
	}
}
